//
//  FSMenuActionManager.h
//  Downloader
//
//  Created by LiDong on 13-3-15.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FSFileOperation.h"
#import "IFActivityView.h"

@class FSFileItem;

@interface FSOperationManager : NSObject <FSFileOperationDelegate, IFActivityViewDelegate> {
    NSOperationQueue *_operationQueue;
    FSFileOperation *_fileOperation;
    IFActivityView *_activityView;
}

@property (nonatomic, retain, readonly) NSOperationQueue *operationQueue;

+ (FSOperationManager *)sharedManager;

- (BOOL)canPaste;
- (void)cancel;
- (void)copyFileItems:(NSArray *)fileItems completionBlock:(FSCompletionHandler)block;
- (void)cutFileItems:(NSArray *)fileItems completionBlock:(FSCompletionHandler)block;
- (void)removeFileItems:(NSArray *)fileItems completionBlock:(FSCompletionHandler)block;
- (void)zipFileItems:(NSArray *)fileItems toPath:(NSString *)dstPath completionBlock:(FSCompletionHandler)block;
- (void)zipFileItems:(NSArray *)fileItems completionBlock:(FSCompletionHandler)block;
- (void)unzipFileItem:(FSFileItem *)fileItem completionBlock:(FSCompletionHandler)block;
- (void)pasteToFileItem:(FSFileItem *)fileItem completionBlock:(FSCompletionHandler)block;

@end
